/*
 * Decompiled with CFR 0.152.
 */
package net.hyper_pigeon.eldritch_mobs.ability.active.offensive;

import net.hyper_pigeon.eldritch_mobs.EldritchMobsMod;
import net.hyper_pigeon.eldritch_mobs.ability.Ability;
import net.hyper_pigeon.eldritch_mobs.ability.AbilitySubType;
import net.hyper_pigeon.eldritch_mobs.ability.AbilityType;
import net.hyper_pigeon.eldritch_mobs.config.EldritchMobsConfig;
import net.minecraft.class_1308;
import net.minecraft.class_1309;

public class BurningAbility
implements Ability {
    private final EldritchMobsConfig.BurningConfig burningConfig;
    private final long cooldown;
    private long nextUseTime;

    public BurningAbility() {
        this.burningConfig = EldritchMobsMod.ELDRITCH_MOBS_CONFIG.burningConfig;
        this.cooldown = this.burningConfig.cooldown;
        this.nextUseTime = 100L;
    }

    @Override
    public String getName() {
        return this.burningConfig.name;
    }

    @Override
    public AbilityType getAbilityType() {
        return AbilityType.ACTIVE;
    }

    @Override
    public AbilitySubType getAbilitySubType() {
        return AbilitySubType.OFFENSIVE;
    }

    @Override
    public long getCooldown() {
        return this.cooldown;
    }

    @Override
    public boolean canUseAbility(class_1308 mobEntity) {
        return mobEntity.method_5770().method_8510() > this.nextUseTime && mobEntity.method_5968() != null;
    }

    @Override
    public void onAbilityUse(class_1308 mobEntity) {
        long time;
        if (!mobEntity.method_5770().method_8608() && mobEntity.method_5968() != null && mobEntity.method_5968().method_5805() && (time = mobEntity.method_5770().method_8510()) > this.nextUseTime) {
            this.nextUseTime = time + this.cooldown;
            class_1309 target = mobEntity.method_5968();
            target.method_5639(this.burningConfig.fireDuration);
        }
    }
}

